//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Anzeige.h"
#pragma package(smart_init)
//---------------------------------------------------------------------------
// ValidCtrCheck wird verwendet, um sicherzustellen, da die erzeugten Komponenten
// keine rein virtuellen Funktionen besitzen.
//

static inline void ValidCtrCheck(TAnzeige *)
{
    new TAnzeige(NULL);
}
//---------------------------------------------------------------------------
__fastcall TAnzeige::TAnzeige(TComponent* Owner)
    : TGraphicControl(Owner)
{
    Width = 25;
    Height = 25;
    FFarbe_on = clAqua;
    FFarbe_off= clBtnFace;
    FStatus = false;
}
//---------------------------------------------------------------------------
void __fastcall TAnzeige::Paint()
{
    int Rahmen = 2;
    // Vorgnger Fkt. aufrufen.
    TGraphicControl::Paint();
    Canvas->Pen->Style = psClear;
    Canvas->Pen->Color = clRed;
    Canvas->Brush->Style = bsSolid;

    if ( FStatus == true )Canvas->Brush->Color = FFarbe_on;
    else Canvas->Brush->Color = FFarbe_off;

    Canvas->Rectangle( 0, 0, ClientWidth , ClientHeight  );

    Canvas->Pen->Color = clBlack;
    Canvas->Pen->Style = psSolid;
    Canvas->Pen->Width = Rahmen;
    // Schwarzer Rahmen
    Canvas->MoveTo(  Rahmen / 2 , Rahmen / 2);
    Canvas->LineTo( Rahmen/2,ClientHeight - Rahmen/2 );
    Canvas->LineTo( ClientWidth - Rahmen/2 ,ClientHeight - Rahmen/2  );
    Canvas->LineTo( ClientWidth - Rahmen/2 , Rahmen/2  );
    Canvas->LineTo( Rahmen/2 , Rahmen/2  );

}
void __fastcall TAnzeige::SetFarbe_on( TColor aWert)
{
    FFarbe_on = aWert;
    Invalidate();
}
void __fastcall TAnzeige::SetFarbe_off( TColor aWert)
{
    FFarbe_off = aWert;
    Invalidate();
}
void __fastcall TAnzeige::SetStatus( bool Zustand )
{
    FStatus = Zustand;
    Invalidate();
}
//---------------------------------------------------------------------------
namespace Anzeige
{
    void __fastcall PACKAGE Register()
    {
        TComponentClass classes[1] = {__classid(TAnzeige)};
        RegisterComponents("Beispiele", classes, 0);
    }
}
//---------------------------------------------------------------------------
